#ifndef PLANET_H
#define PLANET_H

#include <pspgu.h>
#include <vector>
#include <cmath>

class Planet
{
    public : static std::vector<Planet*> planets;

    private : bool done; // planet is finished and can interact
              float mass;
              float x, y;
              float newX, newY;
              float speed;
              float direction; // in radians! 0° is north, 90° is east

    public : static void clearAll();
    public : static void finishAll();

    public : Planet(float mass, float x, float y, float speed=0.0f, float direction=0.0f);

    public : void unfinish();
    public : void finish();
    public : bool finished();

    public : void setMass(float mass);
    public : float getMass();

    // Planet may still have to influence other planets
    // Therefore store new position separately
    public : void planMoving(float x, float y);
    public : void finishMoving();

    // Change actual position
    public : void setX(float x);
    public : void setY(float y);
    public : float getX();
    public : float getY();

    public : void setSpeed(float speed);
    public : float getSpeed();

    public : void setDirection(float direction);
    public : float getDirection();
};
#endif
